﻿using System;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using Microsoft.Practices.EnterpriseLibrary.Data;

[Serializable]
public static class SqlProvider
{
    /// <summary>
    /// PerformUpdate:  This function will perform an update to the database with the given
    /// sql query.
    /// </summary>
    /// <param name="sqlStatement">the query to run </param>
    /// <returns>and integer result.  0 if no errors.</returns>
    public static int PerformUpdate(string connName, string spName, params object[] values)
    {
        if (connName.Length > 0)
        {
            Database db = DatabaseFactory.CreateDatabase(connName);
            DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
            return db.ExecuteNonQuery(dbCommand);
        }
        else
        {
            return -1;
        }
    }

    public static int PerformInsert(string connName, string spName, params object[] values)
    {
        int result = -1;
        if (connName.Length > 0)
        {
            Database db = DatabaseFactory.CreateDatabase(connName);
            DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
            result = db.ExecuteNonQuery(dbCommand);
        }
        return result;
    }
    public static int PerformDelete(string connName, string spName, params object[] values)
    {
        int result = -1;
        if (connName.Length > 0)
        {
            Database db = DatabaseFactory.CreateDatabase(connName);
            DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
            result = db.ExecuteNonQuery(dbCommand);
        }
        return result;
    }


    /// <summary>
    /// ExecuteSPDataset: This function will perform a select call within the database.
    /// </summary>
    /// <param name="sqlStatement">the query to execute within the database.</param>
    /// <returns>A dataset, or null if nothing is returned.</returns>
    public static DataSet ExecuteSPDataset(string connName, string spName, params object[] values)
    {
        if (connName.Length > 0)
        {
            Database db = DatabaseFactory.CreateDatabase(connName);
            DbCommand dbCommand = db.GetStoredProcCommand(spName, values);

            return db.ExecuteDataSet(dbCommand);
        }
        else
            return null;
    }

    public static DataTable ExecuteSPDataTable(string connName, string spName, params object[] values)
    {
        if (connName.Length > 0)
        {
            DataTable dt = null;
            DataSet ds = null;
            try
            {
                dt = new DataTable();
                ds = ExecuteSPDataset(connName, spName, values);
                if ((ds != null) && ds.Tables.Count > 0)
                    dt = ds.Tables[0];
                else
                    dt = null;
            }
            finally
            {
                ds.Dispose();
            }
            return dt;
        }
        else
            return null;
    }

    public static SqlDataReader ExecuteSPReader(string connName, string spName, params object[] values)
    {
        SqlDataReader dr = null;
        if (connName.Length > 0)
        {
            Database db = DatabaseFactory.CreateDatabase(connName);
            DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
            dr = (SqlDataReader)db.ExecuteReader(dbCommand);
        }
        return dr;
    }
    public static object ExecuteScalar(string connName, string spName, params object[] values)
    {
        object result = null;
        if (connName.Length > 0)
        {
            Database db = DatabaseFactory.CreateDatabase(connName);
            DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
            result = db.ExecuteScalar(dbCommand);
        }
        return result;
    }
}
